from bpy.types import PropertyGroup
from bpy.props import FloatProperty, BoolProperty, EnumProperty
from ..updaters.props_update_colliders import props_update_colliders


class ActiveColliderSettingsProps(PropertyGroup):

    """ Propiedades guardadas en el active_collider.settings.x """

    subsections: EnumProperty(
        items=[
            ('SETTINGS',  "Settings",  "", 0),
            ('ANIMATION', "Animation", "", 1),
        ],
        default='SETTINGS'
    )

    permeability: FloatProperty(
        name="Permeability",
        description="Chande that the particle will pass through the mesh",
        default=0,
        min=0,
        max=1,
        update=lambda self, context: props_update_colliders(self, context, "permeability")
    )
    stickiness: FloatProperty(
        name="Stickiness",
        description="Amount of stickiness to furface collision",
        default=0,
        min=0,
        max=10,
        update=lambda self, context: props_update_colliders(self, context, "stickiness")
    )
    use_particle_kill: BoolProperty(
        name="Kill Particles",
        description="Kill collided particles",
        default=False,
        update=lambda self, context: props_update_colliders(self, context, "use_particle_kill")
    )
    damping_factor: FloatProperty(
        name="Damping Factor",
        description="Amount of damping durin particle collision",
        default=1,
        min=0,
        max=1,
        update=lambda self, context: props_update_colliders(self, context, "damping_factor")
    )
    damping_random: FloatProperty(
        name="Random Damping",
        description="Random variation of damping",
        default=0,
        min=0,
        max=1,
        update=lambda self, context: props_update_colliders(self, context, "damping_random")
    )
    friction_factor: FloatProperty(
        name="Friction Factor",
        description="Amount of friction durin particle collision",
        default=0.05,
        min=0,
        max=1,
        update=lambda self, context: props_update_colliders(self, context, "friction_factor")
    )
    friction_random: FloatProperty(
        name="Random Friction",
        description="Random variation of friction",
        default=0,
        min=0,
        max=1,
        update=lambda self, context: props_update_colliders(self, context, "friction_random")
    )


    def get_default_properties(self, target_prop):
        for prop in self.bl_rna.properties:
            if prop.identifier == target_prop:
                if hasattr(prop, "default"):
                    return prop.default